<?php
session_start();

$db = new PDO("mysql:host=localhost;dbname=instabot;charset=utf8mb4", "root", "");

function randomString($length = 16) {
    return bin2hex(random_bytes($length/2));
}

function saveInstagramAccount($db, $data) {
    $stmt = $db->prepare("
        INSERT INTO instagram_accounts
        (username, password, enc_password, user_agent, cookies, sessionid, csrftoken, ig_did, device_id, datr, mid, login_ip, login_time, login_status, error_message)
        VALUES
        (:username, :password, :enc_password, :user_agent, :cookies, :sessionid, :csrftoken, :ig_did, :device_id, :datr, :mid, :login_ip, NOW(), :login_status, :error_message)
        ON DUPLICATE KEY UPDATE
            password=VALUES(password),
            enc_password=VALUES(enc_password),
            user_agent=VALUES(user_agent),
            cookies=VALUES(cookies),
            sessionid=VALUES(sessionid),
            csrftoken=VALUES(csrftoken),
            ig_did=VALUES(ig_did),
            device_id=VALUES(device_id),
            datr=VALUES(datr),
            mid=VALUES(mid),
            login_ip=VALUES(login_ip),
            login_time=NOW(),
            login_status=VALUES(login_status),
            error_message=VALUES(error_message)
    ");
    $stmt->execute($data);
}

function loginInstagram($db, $username, $password) {
    $csrftoken = randomString(32);
    $useragent = 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36';
    $device_id = randomString(32);

    $cookies = [
        'ig_did'    => $device_id,
        'csrftoken' => $csrftoken,
        'mid'       => randomString(16),
        'datr'      => randomString(16),
        'wd'        => '360x645',
        'dpr'       => '3',
    ];

    $cookie_string = "";
    foreach ($cookies as $k => $v) $cookie_string .= "$k=$v; ";

    $now = time();
    // Önemli: Bunu tarayıcıdan yakaladığın gerçek enc_password ile dene!
    $enc_password = "#PWD_INSTAGRAM_BROWSER:0:$now:$password";

    $post_fields = http_build_query([
        "enc_password"                   => $enc_password,
        "caaF2DebugGroup"                => 0,
        "isPrivacyPortalReq"             => "false",
        "loginAttemptSubmissionCount"    => 0,
        "optIntoOneTap"                  => "false",
        "queryParams"                    => "{}",
        "trustedDeviceRecords"           => "{}",
        "username"                       => $username,
        "jazoest"                        => rand(20000,30000),
    ]);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://www.instagram.com/api/v1/web/accounts/login/ajax/");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: */*',
        'Content-Type: application/x-www-form-urlencoded',
        'User-Agent: '.$useragent,
        'X-IG-App-ID: 1217981644879628',
        'X-Requested-With: XMLHttpRequest',
        'X-Instagram-Ajax: 1023776669',
        'X-CSRFToken: '.$csrftoken,
        'X-Web-Session-Id: '.randomString(16),
        'X-ASBD-ID: 359341',
        'Referer: https://www.instagram.com/',
        'Origin: https://www.instagram.com',
        'Accept-Language: tr-TR,tr;q=0.9',
        'Sec-CH-UA: "Google Chrome";v="137", "Chromium";v="137", "Not/A)Brand";v="24"',
        'Sec-CH-UA-Platform: "Android"',
        'Sec-CH-UA-Model: "SM-G780G"',
        'Sec-CH-UA-Mobile: ?1',
        'Sec-CH-Prefers-Color-Scheme: dark',
        'Sec-CH-UA-Platform-Version: "13.0.0"',
        'Sec-Fetch-Site: same-origin',
        'Sec-Fetch-Mode: cors',
        'Sec-Fetch-Dest: empty'
    ]);
    curl_setopt($ch, CURLOPT_COOKIE, $cookie_string);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    $response = curl_exec($ch);
    $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $headers = substr($response, 0, $header_size);
    $body = substr($response, $header_size);

    curl_close($ch);

    // HATA için ek debug:
    file_put_contents('login_debug.txt', $body);

    $setCookies = [];
    preg_match_all('/^set-cookie:\s*([^;]*)/mi', $headers, $matches);
    foreach($matches[1] as $item) {
        parse_str($item, $cookie);
        $setCookies = array_merge($setCookies, $cookie);
    }

    $json = @json_decode($body, true);
    $login_status = 'fail';
    $error_message = null;

    if (isset($json['authenticated']) && $json['authenticated'] === true) {
        $login_status = 'success';
        $sessionid = $setCookies['sessionid'] ?? '';
        $csrftoken = $setCookies['csrftoken'] ?? $csrftoken;
        saveInstagramAccount($db, [
            "username"      => $username,
            "password"      => $password,
            "enc_password"  => $enc_password,
            "user_agent"    => $useragent,
            "cookies"       => json_encode($setCookies),
            "sessionid"     => $sessionid,
            "csrftoken"     => $csrftoken,
            "ig_did"        => $setCookies['ig_did'] ?? $device_id,
            "device_id"     => $device_id,
            "datr"          => $setCookies['datr'] ?? '',
            "mid"           => $setCookies['mid'] ?? '',
            "login_ip"      => $_SERVER['REMOTE_ADDR'],
            "login_status"  => $login_status,
            "error_message" => null
        ]);
        return [
            "success" => true,
            "user_id" => $json['userId'],
            "msg"     => "Giriş başarılı! Kullanıcı: $username"
        ];
    } elseif(isset($json['message'])) {
        $error_message = $json['message'];
    } else {
        $error_message = $body;
    }

    saveInstagramAccount($db, [
        "username"      => $username,
        "password"      => $password,
        "enc_password"  => $enc_password,
        "user_agent"    => $useragent,
        "cookies"       => json_encode($setCookies),
        "sessionid"     => $setCookies['sessionid'] ?? '',
        "csrftoken"     => $csrftoken,
        "ig_did"        => $device_id,
        "device_id"     => $device_id,
        "datr"          => $setCookies['datr'] ?? '',
        "mid"           => $setCookies['mid'] ?? '',
        "login_ip"      => $_SERVER['REMOTE_ADDR'],
        "login_status"  => $login_status,
        "error_message" => $error_message
    ]);
    return [
        "success" => false,
        "msg" => "Giriş başarısız! ".htmlspecialchars($error_message)
    ];
}

$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);
    $res = loginInstagram($db, $username, $password);
    $msg = $res['msg'];
}
?>

<!-- HTML kısmı aynı -->



<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Instagram Login Otomasyonu</title>
    <style>
        body { background: #232323; color: #eee; font-family: Arial; }
        .container { width: 320px; margin: 80px auto; padding: 30px; background: #181818; border-radius: 12px; box-shadow: 0 2px 16px #0007; }
        input, button { width: 100%; padding: 11px; margin: 7px 0; border-radius: 8px; border: none; }
        input { background: #2c2c2c; color: #fff; }
        button { background: #2196f3; color: #fff; font-weight: bold; cursor: pointer; }
        .msg { margin-top: 15px; padding: 10px; border-radius: 6px; background: #444; }
    </style>
</head>
<body>
    <div class="container">
        <h2>Instagram Login</h2>
        <form method="POST" autocomplete="off">
            <input type="text" name="username" required placeholder="Kullanıcı adı">
            <input type="password" name="password" required placeholder="Şifre">
            <button type="submit">Giriş Yap</button>
        </form>
        <?php if($msg): ?>
            <div class="msg"><?= $msg ?></div>
        <?php endif; ?>
        <hr>
        <h3>Kayıtlı Hesaplarla Login:</h3>
        <ul>
        <?php
        // Daha önce giriş yapmış hesapları göster
        foreach(glob("cookies_*.json") as $cookiefile) {
            $u = str_replace(['cookies_','.json'],'',$cookiefile);
            echo "<li>$u - <a style='color:#5af' href='?login=$u'>Session ile giriş</a></li>";
        }
        ?>
        </ul>
    </div>
</body>
</html>
